/*
 * This File is one of the examples from Java For Beginners
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */
package chapter9.datetime;

/**
 *
 * @author Matthew Gregory
 * @website www.matthewgregory-author.com.au
 *
 */
public class Meeting {

    public Person host;

    //Agenda Items
    public String[] agendaItems;

    //Attendees
    public Person[] attendees;
    //Meeting Date

    
    //No-arg constructor
    public Meeting(){}
    
    public void printAgenda() {
        System.out.println("Items on the Agenda: ");
        for (int i = 0; i <= 2; i++) {
            System.out.println((i + 1) + ". " + agendaItems[i]);
        }
    }

    public void printAttendees() {
        System.out.println("List of People Attending the Meeting, ");
        System.out.println();//Put a blank line between header and host.
        System.out.println("Hosted by: ");
        host.printDetails();
        System.out.println();//Put a blank line between host and attendees.
        System.out.println("Attendees: ");
        for (Person attendee : attendees) {
            //Note that you can make use of built-in methods and fields
            attendee.printDetails();//print out each persons details
        }
    }
    
    //Creating an appropriate construtor.
    /*
    //Passing the array as a paramter
    public Meeting(Person host,Person[] attendees){
        this.host=host;
        this.attendees=attendees;
    }
    
    //Allowing people to pass in the host, and various numbers of attendees.
    //Single attendee.
    public Meeting(Person host,Person attendee1){
        this.host=host;
        //construct the array based on parameters
        Person[] temp={attendee1};
        //assign the array to the field
        this.attendees=temp;
    }
    //Two attendees
    public Meeting(Person host,Person attendee1,Person attendee2){
        this.host=host;
        //construct the array based on parameters
        Person[] temp={attendee1};
        //assign the array to the field
        this.attendees=temp;
    }
    //Three attendees
    public Meeting(Person host,Person attendee1,Person attendee2,Person attendee3){
        this.host=host;
        //construct the array based on parameters
        Person[] temp={attendee1,attendee2,attendee3};
        //assign the array to the field
        this.attendees=temp;
    }
    //Four attendees
    public Meeting(Person host,Person attendee1,Person attendee2,Person attendee3,Person attendee4){
        this.host=host;
        //construct the array based on parameters
        Person[] temp={attendee1,attendee2,attendee3,attendee4};
        //assign the array to the field
        this.attendees=temp;
    }
    //We could keep going forever...
    */
    
    //The solution is a variable argument parameter.
    public Meeting(Person host,Person... attendees){
        this.host=host;
        //assign the array to the field
        this.attendees=attendees;
    }
    
}
